﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductsXCategoryBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductsXCategory GetItem(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            return ProductsXCategoryDB.GetItem(productsXCategoryID, productsID, productCategoryID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductsXCategory> GetList(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            return ProductsXCategoryDB.GetList(productsXCategoryID, productsID, productCategoryID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            return ProductsXCategoryDB.GetDataTable(productsXCategoryID, productsID, productCategoryID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            return ProductsXCategoryDB.GetDataSet(productsXCategoryID, productsID, productCategoryID);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductsXCategory myProductCategory)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
            ProductsXCategoryDB.Save(myProductCategory);

                myTransactionScope.Complete();
            return true;
            }
        }
    }
}
